<?php
/*
Plugin Name: Notas Internas
Description: Permite gestionar tareas, descripciones, fechas, archivos y recordatorios desde el panel de administración de WordPress.
Version: 1.3
Author: SGC
*/

if ( ! defined( 'ABSPATH' ) ) exit;

// Registrar el CPT "nota"
function sgc_registrar_post_type_nota() {
    register_post_type( 'nota', array(
        'labels' => array(
            'name' => 'Notas',
            'singular_name' => 'Nota',
            'add_new' => 'Añadir nueva',
            'add_new_item' => 'Añadir nueva nota',
            'edit_item' => 'Editar nota',
            'new_item' => 'Nueva nota',
            'view_item' => 'Ver nota',
            'search_items' => 'Buscar notas',
            'not_found' => 'No se encontraron notas',
            'not_found_in_trash' => 'No hay notas en la papelera'
        ),
        'public' => false,
        'show_ui' => true,
        'menu_position' => 25,
        'menu_icon' => 'dashicons-welcome-write-blog',
        'supports' => array( 'title' ),
        'capability_type' => 'post',
        'show_in_menu' => true
    ));
}
add_action( 'init', 'sgc_registrar_post_type_nota' );

function sgc_add_meta_boxes() {
    add_meta_box('sgc_campos_nota', 'Información de la Nota', 'sgc_campos_nota_callback', 'nota', 'normal', 'default');
    add_meta_box('sgc_notificacion', 'Notificación', 'sgc_notificacion_callback', 'nota', 'normal', 'default');
}
add_action('add_meta_boxes', 'sgc_add_meta_boxes');

function sgc_campos_nota_callback($post) {
    $tarea = get_post_meta($post->ID, '_sgc_tarea', true);
    $descripcion = get_post_meta($post->ID, '_sgc_descripcion', true);
    $fecha = get_post_meta($post->ID, '_sgc_fecha', true);
    $archivo = get_post_meta($post->ID, '_sgc_archivo', true);
    ?>
    <p>
        <label for="sgc_tarea"><strong>Tarea:</strong></label><br>
        <input type="text" name="sgc_tarea" id="sgc_tarea" value="<?php echo esc_attr($tarea); ?>" style="width:100%">
    </p>
    <p>
        <label for="sgc_fecha"><strong>Fecha:</strong></label><br>
        <input type="date" name="sgc_fecha" id="sgc_fecha" value="<?php echo esc_attr($fecha); ?>" style="width:100%; cursor: pointer;">
    </p>
    <p>
        <label for="sgc_archivo"><strong>Archivo adjunto:</strong></label><br>
        <input type="hidden" name="sgc_archivo" id="sgc_archivo" value="<?php echo esc_attr($archivo); ?>">
        <button type="button" class="button" id="sgc_upload_button">Seleccionar archivo</button>
        <div id="sgc_preview">
            <?php if ($archivo) echo wp_get_attachment_link($archivo); ?>
        </div>
    </p>
    <p>
        <label for="sgc_descripcion"><strong>Descripción:</strong></label><br>
        <?php
        wp_editor(
            $descripcion,
            'sgc_descripcion',
            array(
                'textarea_name' => 'sgc_descripcion',
                'media_buttons' => false,
                'textarea_rows' => 6,
                'teeny' => false,
                'quicktags' => true
            )
        );
        ?>
    </p>
    <script>
        jQuery(document).ready(function($){
            let frame;
            $('#sgc_upload_button').on('click', function(e){
                e.preventDefault();
                if (frame) {
                    frame.open();
                    return;
                }
                frame = wp.media({
                    title: 'Seleccionar archivo',
                    button: { text: 'Usar este archivo' },
                    multiple: false
                });
                frame.on('select', function(){
                    const attachment = frame.state().get('selection').first().toJSON();
                    $('#sgc_archivo').val(attachment.id);
                    $('#sgc_preview').html('<a href="'+attachment.url+'" target="_blank">'+attachment.filename+'</a>');
                });
                frame.open();
            });
        });
    </script>
    <?php
}

function sgc_notificacion_callback($post) {
    $notif_fecha = get_post_meta($post->ID, '_sgc_notif_fecha', true);
    $notif_hora = get_post_meta($post->ID, '_sgc_notif_hora', true);
    $notif_mensaje = get_post_meta($post->ID, '_sgc_notif_mensaje', true);
    ?>
    <p>
        <label for="sgc_notif_fecha"><strong>Fecha de notificación:</strong></label><br>
        <input type="date" name="sgc_notif_fecha" id="sgc_notif_fecha" value="<?php echo esc_attr($notif_fecha); ?>" style="width:100%; cursor:pointer;">
    </p>
    <p>
        <label for="sgc_notif_hora"><strong>Hora de notificación:</strong></label><br>
        <input type="time" name="sgc_notif_hora" id="sgc_notif_hora" value="<?php echo esc_attr($notif_hora); ?>" style="width:100%;">
    </p>
    <p>
        <label for="sgc_notif_mensaje"><strong>Mensaje a enviar:</strong></label><br>
        <textarea name="sgc_notif_mensaje" id="sgc_notif_mensaje" rows="4" style="width:100%; resize: vertical;"><?php echo esc_textarea($notif_mensaje); ?></textarea>
    </p>
    <?php
}

function sgc_guardar_datos_nota($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    $campos = [
        'sgc_tarea', 'sgc_descripcion', 'sgc_fecha', 'sgc_archivo',
        'sgc_notif_fecha', 'sgc_notif_hora', 'sgc_notif_mensaje'
    ];

    foreach ($campos as $campo) {
        if (isset($_POST[$campo])) {
            $valor = is_array($_POST[$campo]) ? array_map('sanitize_text_field', $_POST[$campo]) : wp_unslash($_POST[$campo]);
            update_post_meta($post_id, "_{$campo}", $valor);
        }
    }
}
add_action('save_post', 'sgc_guardar_datos_nota');
